/* --------------------------------------------------------------
 order_cc.js 2015-10-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2015 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * ## CC Payment Details on Order Page
 *
 * This module add the cc payment informationen to the order details page.
 *
 * @module Compatibility/order_cc
 */
gx.compatibility.module(
    'order_cc',

    [],

    /**  @lends module:Compatibility/order_cc */

    function (data) {

        'use strict';

        // ------------------------------------------------------------------------
        // VARIABLES DEFINITION
        // ------------------------------------------------------------------------

        var
            /**
             * Module Selector
             *
             * @var {object}
             */
            $this = $(this),

            /**
             * Default Options
             *
             * @type {object}
             */
            defaults = {},

            /**
             * Final Options
             *
             * @var {object}
             */
            options = $.extend(true, {}, defaults, data),

            /**
             * Module Object
             *
             * @type {object}
             */
            module = {};

        // ------------------------------------------------------------------------
        // INITIALIZATION
        // ------------------------------------------------------------------------

        module.init = function (done) {

            if ($('.cc').length > 0) {
                $this.append($('.cc'));
                $this.parents('.content:first').show();
            }

            done();
        };

        return module;
    });
